function [residual, g1, g2, g3] = QuantMig_D92_DSGE_EtW_V1_2_19_Oct_21_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations.
%                                          Dynare may prepend or append auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g3        [M_.endo_nbr by (M_.endo_nbr)^3] double   Third derivatives matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 157, 1);

%
% Model equations
%

uuem_t__ = exp(y(71))-exp(y(68));
uuee_t__ = exp(y(70))-exp(y(36));
uuemlag__ = exp(y(71))-exp(y(68));
uueelag__ = exp(y(70))-exp(y(36));
WE_t__ = exp(y(10))+params(1)*(exp(y(10))*(1-params(30))+params(30)*params(185));
UE_t__ = params(185)+params(1)*(exp(y(10))*exp(y(44))+params(185)*(1-exp(y(44))));
WM_t__ = exp(y(78))+params(1)*(exp(y(78))*(1-params(56))+params(56)*params(186));
UM_t__ = params(186)+params(1)*(exp(y(78))*exp(y(74))+params(186)*(1-exp(y(74))));
EC_t__ = params(307)/2*((exp(y(70))+exp(y(1))-exp(y(36)))/(exp(y(71))+exp(y(69))-exp(y(68))))^(-2);
T70 = exp(y(70))+exp(y(1))-exp(y(36));
T74 = exp(y(71))+exp(y(69))-exp(y(68));
T153 = params(29)*exp(y(70))^params(33);
T157 = exp(y(38))^(1-params(33));
T163 = params(31)*exp(y(84))^params(34);
T167 = exp(y(48))^(1-params(34));
T173 = params(55)*exp(y(71))^params(54);
T177 = exp(y(72))^(1-params(54));
T182 = params(203)*exp(y(85))^params(54);
T185 = exp(y(86))^(1-params(54));
T361 = exp(y(50))*exp(y(17))*(1-params(32))*params(2)/exp(y(17));
T373 = params(1)*exp(y(3))/exp(y(3));
T389 = exp(y(17))*params(2)/exp(y(17));
T469 = exp(y(129))*exp(y(133))*(1-params(244))/exp(y(42));
T503 = exp(y(138))*exp(y(3))*params(1)*(1-params(244))/exp(y(3));
T520 = exp(y(63))^params(274);
T527 = exp(y(133))*exp(y(132))+exp(y(62))*params(131)*exp(y(60));
T529 = T527^(-params(274));
T574 = exp(y(140))*exp(y(130))*(1-params(257))/exp(y(52));
T608 = exp(y(145))*exp(y(17))*params(2)*(1-params(257))/exp(y(17));
T621 = params(53)^(1/params(300));
T628 = (1-params(53))^(1/params(300));
T631 = T621*exp(y(23))^params(52)+T628*exp(y(21))^params(52);
T639 = (1-params(273))*exp(y(98))^params(51);
T640 = params(273)*T631^(params(51)/params(52))+T639;
T642 = 1/params(51)-1;
T643 = T640^T642;
T646 = exp(y(98))^(params(51)-1);
T647 = (1-params(273))*exp(y(59))*params(306)*T643*T646;
T682 = exp(y(147))*exp(y(130))*(1-params(270))/exp(y(52));
T716 = exp(y(152))*exp(y(17))*params(2)*(1-params(270))/exp(y(17));
T723 = T527^(1-params(274));
T761 = T639+params(273)*exp(y(66))^params(51);
T763 = exp(y(59))*params(306)*T761^(1/params(51));
T797 = T761^T642;
T800 = T631^(params(51)/params(52)-1);
T803 = exp(y(23))^(params(52)-1);
T813 = exp(y(21))^(params(52)-1);
T896 = params(274)*exp(y(58))*exp(y(63))^(params(274)-1);
T897 = T723*T896;
T925 = exp(y(33))^(1-params(5));
T930 = exp(y(33))^(params(5)-1);
T955 = params(3)*exp(y(31))^(-params(5));
T970 = exp(y(38))*(1-exp(y(43)))*exp(y(134))*exp(y(137))*params(245)/(1+params(245));
T975 = exp(y(139))*exp(y(135))*params(246)/(1+params(246));
T976 = y(45)+exp(y(5))+exp(y(6))+exp(y(43))*params(39)+exp(y(104))+exp(y(133))*params(243)+T970+T975;
T983 = params(4)*(1-params(24))/params(24)*exp(y(35))^(-params(5));
T1007 = exp(y(72))*(1-exp(y(73)))*exp(y(148))*exp(y(151))*params(271)/(1+params(271));
T1012 = exp(y(153))*exp(y(149))*params(272)/(1+params(272));
T1021 = exp(y(86))*(1-exp(y(87)))*exp(y(141))*exp(y(144))*params(258)/(1+params(258));
T1026 = exp(y(146))*exp(y(142))*params(259)/(1+params(259));
T1027 = y(75)+y(89)+y(55)+exp(y(19))+exp(y(20))+exp(y(53))*params(41)+exp(y(87))*params(208)+exp(y(73))*params(60)+exp(y(108))+exp(y(113))+exp(y(147))*params(269)+T1007+T1012+exp(y(140))*params(256)+T1021+T1026;
T1033 = exp(y(32))/exp(y(30));
T1035 = (1-params(4))*T1033^(-params(5));
T1040 = (1-params(3))*params(24)/(1-params(24))*exp(y(32))^(-params(5));
T1058 = exp(y(32))*(1+y(2))*exp(y(8))/exp(y(8))/exp(y(32));
T1096 = exp(y(78))/exp(y(10));
T1109 = exp(y(110))*(exp(y(69))+uuem_t__)/(uuem_t__+1+exp(y(69)));
T1122 = params(184)^(1-params(65));
T1159 = params(180)^(1-params(65));
T1190 = params(70)^(1-params(18));
T1207 = params(70)^(1-params(20));
T1225 = params(176)^(1-params(21));
T1265 = params(230)^(1-params(231));
T1274 = params(232)^(1-params(233));
lhs =exp(y(3));
rhs =(exp(y(114))*exp(y(5)))^(-params(13));
residual(1)= lhs-rhs;
lhs =exp(y(64));
rhs =params(15)*exp(y(11))^params(14);
residual(2)= lhs-rhs;
lhs =exp(y(81));
rhs =params(197)*exp(y(126))^params(14);
residual(3)= lhs-rhs;
lhs =exp(y(62));
rhs =exp(y(1))*exp(y(11));
residual(4)= lhs-rhs;
lhs =exp(y(80));
rhs =exp(y(69))*exp(y(126));
residual(5)= lhs-rhs;
lhs =exp(y(17));
rhs =exp(y(19))^(-params(13));
residual(6)= lhs-rhs;
lhs =exp(y(65));
rhs =params(17)*exp(y(26))^params(16);
residual(7)= lhs-rhs;
lhs =exp(y(94));
rhs =params(198)*exp(y(127))^params(16);
residual(8)= lhs-rhs;
lhs =exp(y(21));
rhs =exp(y(26))*exp(y(15));
residual(9)= lhs-rhs;
lhs =exp(y(128));
rhs =exp(y(127))*exp(y(83));
residual(10)= lhs-rhs;
lhs =exp(y(36));
rhs =T153*T157;
residual(11)= lhs-rhs;
lhs =exp(y(46));
rhs =T163*T167;
residual(12)= lhs-rhs;
lhs =exp(y(68));
rhs =T173*T177;
residual(13)= lhs-rhs;
lhs =exp(y(82));
rhs =T182*T185;
residual(14)= lhs-rhs;
lhs =exp(y(1));
rhs =exp(y(36))+(1-params(30))*exp(y(1));
residual(15)= lhs-rhs;
lhs =exp(y(15));
rhs =exp(y(46))+exp(y(15))*(1-params(32));
residual(16)= lhs-rhs;
lhs =exp(y(69));
rhs =exp(y(68))+(1-params(56))*exp(y(69));
residual(17)= lhs-rhs;
lhs =exp(y(83));
rhs =exp(y(82))+exp(y(83))*(1-params(204));
residual(18)= lhs-rhs;
lhs =exp(y(37));
rhs =1-(1-params(30))*exp(y(1))-(1-params(56))*exp(y(69));
residual(19)= lhs-rhs;
lhs =exp(y(100));
rhs =1-exp(y(1))-exp(y(69));
residual(20)= lhs-rhs;
lhs =exp(y(70));
rhs =exp(y(37))*exp(y(103));
residual(21)= lhs-rhs;
lhs =exp(y(71));
rhs =exp(y(37))*(1-exp(y(103)));
residual(22)= lhs-rhs;
lhs =exp(y(47));
rhs =1-exp(y(15))*(1-params(32))-exp(y(83))*(1-params(204));
residual(23)= lhs-rhs;
lhs =exp(y(99));
rhs =1-exp(y(15))-exp(y(83));
residual(24)= lhs-rhs;
lhs =exp(y(84));
rhs =params(275)-exp(y(15))*(1-params(32));
residual(25)= lhs-rhs;
lhs =exp(y(85));
rhs =params(276)-exp(y(83))*(1-params(204));
residual(26)= lhs-rhs;
lhs =exp(y(102));
rhs =(exp(y(71))-exp(y(68)))/T74;
residual(27)= lhs-rhs;
lhs =exp(y(101));
rhs =(exp(y(70))-exp(y(36)))/T70;
residual(28)= lhs-rhs;
lhs =exp(y(95));
rhs =(exp(y(84))-exp(y(46)))/(exp(y(84))+exp(y(15))-exp(y(46)));
residual(29)= lhs-rhs;
lhs =exp(y(96));
rhs =(exp(y(85))-exp(y(82)))/(exp(y(85))+exp(y(83))-exp(y(82)));
residual(30)= lhs-rhs;
lhs =exp(y(44))*WE_t__+(1-exp(y(44)))*UE_t__+EC_t__;
rhs =exp(y(154))*(exp(y(74))*WM_t__+(1-exp(y(74)))*UM_t__);
residual(31)= lhs-rhs;
lhs =exp(y(43));
rhs =exp(y(36))/exp(y(38));
residual(32)= lhs-rhs;
lhs =exp(y(53));
rhs =exp(y(46))/exp(y(48));
residual(33)= lhs-rhs;
lhs =exp(y(73));
rhs =exp(y(68))/exp(y(72));
residual(34)= lhs-rhs;
lhs =exp(y(87));
rhs =exp(y(82))/exp(y(86));
residual(35)= lhs-rhs;
lhs =exp(y(44));
rhs =exp(y(36))/exp(y(70));
residual(36)= lhs-rhs;
lhs =exp(y(74));
rhs =exp(y(68))/exp(y(71));
residual(37)= lhs-rhs;
lhs =exp(y(54));
rhs =exp(y(46))/exp(y(84));
residual(38)= lhs-rhs;
lhs =exp(y(88));
rhs =exp(y(82))/exp(y(85));
residual(39)= lhs-rhs;
lhs =exp(y(116));
rhs =exp(y(38))/exp(y(70));
residual(40)= lhs-rhs;
lhs =exp(y(117));
rhs =exp(y(48))/exp(y(84));
residual(41)= lhs-rhs;
lhs =exp(y(118));
rhs =exp(y(72))/exp(y(71));
residual(42)= lhs-rhs;
lhs =exp(y(97));
rhs =exp(y(86))/exp(y(85));
residual(43)= lhs-rhs;
lhs =exp(y(50));
rhs =(1-params(36))/params(36)*exp(y(51));
residual(44)= lhs-rhs;
lhs =exp(y(40));
rhs =(1-params(35))/params(35)*exp(y(41));
residual(45)= lhs-rhs;
lhs =exp(y(77));
rhs =(1-params(57))/params(57)*exp(y(76));
residual(46)= lhs-rhs;
lhs =exp(y(91));
rhs =(1-params(205))/params(205)*exp(y(90));
residual(47)= lhs-rhs;
lhs =exp(y(50));
rhs =exp(y(26))*(exp(y(65))-exp(y(25)))+T361;
residual(48)= lhs-rhs;
lhs =exp(y(41));
rhs =(-params(15))/(1+params(14))*exp(y(11))^(1+params(14))+exp(y(10))*exp(y(11))-params(185)+(1-params(30))*(1-exp(y(44)))*exp(y(41))*T373;
residual(49)= lhs-rhs;
lhs =exp(y(51));
rhs =(-params(17))/(1+params(16))*exp(y(26))^(1+params(16))+exp(y(26))*exp(y(25))-params(187)+(1-params(32))*exp(y(51))*T389*(1-exp(y(54)));
residual(50)= lhs-rhs;
lhs =exp(y(76));
rhs =(-params(197))/(1+params(14))*exp(y(126))^(1+params(14))+exp(y(78))*exp(y(126))-params(186)+(1-params(56))*(1-exp(y(74)))*exp(y(76))*T373;
residual(51)= lhs-rhs;
lhs =exp(y(90));
rhs =(-params(198))/(1+params(16))*exp(y(127))^(1+params(16))+exp(y(127))*exp(y(92))-params(229)+(1-params(204))*exp(y(90))*T389*(1-exp(y(88)));
residual(52)= lhs-rhs;
lhs =exp(y(53))*(exp(y(50))-params(41));
rhs =y(56)+T389*y(57);
residual(53)= lhs-rhs;
lhs =exp(y(40));
rhs =exp(y(11))*(exp(y(64))-exp(y(10)))+T373*((1-params(30))*exp(y(40))+params(30)*exp(y(139)));
residual(54)= lhs-rhs;
lhs =exp(y(139));
rhs =(-params(39))+exp(y(43))*exp(y(40))+T373*(1-exp(y(43)))*(exp(y(139))*(1-exp(y(137)))+exp(y(137))*exp(y(138)));
residual(55)= lhs-rhs;
lhs =exp(y(133));
rhs =T469+exp(y(38))*(1-exp(y(43)))*exp(y(137));
residual(56)= lhs-rhs;
lhs =exp(y(38));
rhs =(1-exp(y(137)))*exp(y(38))*(1-exp(y(43)))+params(30)*exp(y(1))+exp(y(135));
residual(57)= lhs-rhs;
lhs =exp(y(134));
rhs =exp(y(138))-exp(y(139));
residual(58)= lhs-rhs;
lhs =exp(y(137));
rhs =(exp(y(134))/params(242))^params(245);
residual(59)= lhs-rhs;
lhs =exp(y(135));
rhs =(exp(y(139))/params(241))^params(246);
residual(60)= lhs-rhs;
lhs =exp(y(138));
rhs =exp(y(136))-params(243)+T503;
residual(61)= lhs-rhs;
lhs =exp(y(39));
rhs =(1-params(274))*params(131)*exp(y(60))*exp(y(58))*T520*T529;
residual(62)= lhs-rhs;
lhs =exp(y(136));
rhs =T529*T520*exp(y(58))*(1-params(274))*exp(y(132));
residual(63)= lhs-rhs;
lhs =exp(y(91));
rhs =exp(y(127))*(exp(y(94))-exp(y(92)))+T389*((1-params(204))*exp(y(91))+params(204)*exp(y(146)));
residual(64)= lhs-rhs;
lhs =exp(y(146));
rhs =(-params(208))+exp(y(87))*exp(y(91))+T389*(1-exp(y(87)))*(exp(y(146))*(1-exp(y(144)))+exp(y(144))*exp(y(145)));
residual(65)= lhs-rhs;
lhs =exp(y(140));
rhs =T574+exp(y(86))*(1-exp(y(87)))*exp(y(144));
residual(66)= lhs-rhs;
lhs =exp(y(86));
rhs =(1-exp(y(144)))*exp(y(86))*(1-exp(y(87)))+exp(y(83))*params(204)+exp(y(142));
residual(67)= lhs-rhs;
lhs =exp(y(141));
rhs =exp(y(145))-exp(y(146));
residual(68)= lhs-rhs;
lhs =exp(y(144));
rhs =(exp(y(141))/params(255))^params(258);
residual(69)= lhs-rhs;
lhs =exp(y(142));
rhs =(exp(y(146))/params(254))^params(259);
residual(70)= lhs-rhs;
lhs =exp(y(145));
rhs =exp(y(143))-params(256)+T608;
residual(71)= lhs-rhs;
lhs =exp(y(143));
rhs =T647;
residual(72)= lhs-rhs;
lhs =exp(y(77));
rhs =exp(y(126))*(exp(y(81))-exp(y(78)))+T389*((1-params(56))*exp(y(77))+params(56)*exp(y(153)));
residual(73)= lhs-rhs;
lhs =exp(y(153));
rhs =(-params(60))+exp(y(73))*exp(y(77))+T389*(1-exp(y(73)))*(exp(y(153))*(1-exp(y(151)))+exp(y(151))*exp(y(152)));
residual(74)= lhs-rhs;
lhs =exp(y(147));
rhs =T682+exp(y(72))*(1-exp(y(73)))*exp(y(151));
residual(75)= lhs-rhs;
lhs =exp(y(72));
rhs =(1-exp(y(151)))*exp(y(72))*(1-exp(y(73)))+params(56)*exp(y(69))+exp(y(149));
residual(76)= lhs-rhs;
lhs =exp(y(148));
rhs =exp(y(152))-exp(y(153));
residual(77)= lhs-rhs;
lhs =exp(y(151));
rhs =(exp(y(148))/params(268))^params(271);
residual(78)= lhs-rhs;
lhs =exp(y(149));
rhs =(exp(y(153))/params(267))^params(272);
residual(79)= lhs-rhs;
lhs =exp(y(152));
rhs =exp(y(150))-params(269)+T716;
residual(80)= lhs-rhs;
lhs =exp(y(150));
rhs =T647;
residual(81)= lhs-rhs;
lhs =exp(y(4));
rhs =exp(y(58))*T520*T723;
residual(82)= lhs-rhs;
lhs =exp(y(63));
rhs =exp(y(63))*(1-params(9))/exp(y(42))+y(12);
residual(83)= lhs-rhs;
lhs =exp(y(9));
rhs =T373*(exp(y(31))*exp(y(61))+(1-params(9))*exp(y(9))/exp(y(42)));
residual(84)= lhs-rhs;
lhs =1;
rhs =exp(y(9))*y(13)+params(1)*exp(y(9))*y(14);
residual(85)= lhs-rhs;
lhs =exp(y(64));
rhs =exp(y(39))*exp(y(31));
residual(86)= lhs-rhs;
lhs =exp(y(18));
rhs =T763;
residual(87)= lhs-rhs;
lhs =exp(y(66));
rhs =T631^(1/params(52));
residual(88)= lhs-rhs;
lhs =exp(y(23));
rhs =exp(y(23))*(1-params(10))/exp(y(52))+y(27);
residual(89)= lhs-rhs;
lhs =exp(y(24));
rhs =T389*(exp(y(34))*exp(y(67))+(1-params(10))*exp(y(24))/exp(y(52)));
residual(90)= lhs-rhs;
lhs =1;
rhs =exp(y(24))*y(28)+params(2)*exp(y(24))*y(29);
residual(91)= lhs-rhs;
lhs =exp(y(67));
rhs =params(306)*exp(y(59))*params(273)*T621*T797*T800*T803;
residual(92)= lhs-rhs;
lhs =exp(y(49));
rhs =T800*T797*params(306)*exp(y(59))*params(273)*T628*T813;
residual(93)= lhs-rhs;
lhs =exp(y(79));
rhs =T646*T643*params(306)*exp(y(59))*(1-params(273))*exp(y(155));
residual(94)= lhs-rhs;
lhs =exp(y(93));
rhs =T646*T643*params(306)*exp(y(59))*(1-params(273))*exp(y(155));
residual(95)= lhs-rhs;
lhs =exp(y(34))*exp(y(49));
rhs =exp(y(65));
residual(96)= lhs-rhs;
lhs =exp(y(34))*exp(y(79));
rhs =exp(y(81));
residual(97)= lhs-rhs;
lhs =exp(y(34))*exp(y(93));
rhs =exp(y(94));
residual(98)= lhs-rhs;
lhs =exp(y(98));
rhs =exp(y(140))*exp(y(131))+exp(y(147))*exp(y(131))+exp(y(80))*exp(y(155))+exp(y(128))*exp(y(155));
residual(99)= lhs-rhs;
lhs =y(12);
rhs =params(11)*exp(y(6));
residual(100)= lhs-rhs;
lhs =y(13);
rhs =y(12)/exp(y(6));
residual(101)= lhs-rhs;
residual(102) = y(14);
lhs =y(27);
rhs =params(11)*exp(y(20));
residual(103)= lhs-rhs;
lhs =y(28);
rhs =y(27)/exp(y(20));
residual(104)= lhs-rhs;
residual(105) = y(29);
lhs =y(45);
rhs =exp(y(38))*params(40);
residual(106)= lhs-rhs;
lhs =y(55);
rhs =exp(y(48))*params(42);
residual(107)= lhs-rhs;
lhs =y(56);
rhs =y(55)/exp(y(48));
residual(108)= lhs-rhs;
residual(109) = y(57);
lhs =y(75);
rhs =exp(y(72))*params(59);
residual(110)= lhs-rhs;
lhs =y(89);
rhs =exp(y(86))*params(207);
residual(111)= lhs-rhs;
lhs =exp(y(61));
rhs =T897;
residual(112)= lhs-rhs;
lhs =1/(1+y(2));
rhs =T373*exp(y(32))/exp(y(32))*1/exp(y(42));
residual(113)= lhs-rhs;
lhs =1/(1+y(16));
rhs =T389*exp(y(34))/exp(y(34))*1/exp(y(52));
residual(114)= lhs-rhs;
lhs =exp(y(31))^(params(5)-1);
rhs =params(3)+(1-params(3))*T925;
residual(115)= lhs-rhs;
lhs =exp(y(32))^(params(5)-1);
rhs =1-params(3)+params(3)*T930;
residual(116)= lhs-rhs;
lhs =exp(y(30))^(1-params(5));
rhs =(params(4)+T925*(1-params(4)))/(params(3)+(1-params(3))*T925);
residual(117)= lhs-rhs;
lhs =exp(y(35))^(params(5)-1);
rhs =params(4)+T925*(1-params(4));
residual(118)= lhs-rhs;
lhs =exp(y(34))^(params(5)-1);
rhs =1-params(4)+T930*params(4);
residual(119)= lhs-rhs;
lhs =exp(y(8));
rhs =T955*T976+T983*T1027;
residual(120)= lhs-rhs;
lhs =exp(y(22));
rhs =T1027*T1035+T976*T1040;
residual(121)= lhs-rhs;
lhs =y(119);
rhs =exp(y(8))-exp(y(5))-exp(y(6))-exp(y(43))*params(39)-y(45)-exp(y(104))-exp(y(133))*params(243)-T970-T975;
residual(122)= lhs-rhs;
lhs =y(7);
rhs =y(7)*T1058/exp(y(42))+y(120);
residual(123)= lhs-rhs;
lhs =1+y(2);
rhs =(1+y(16)+y(115))*exp((-params(7))*(y(7)-params(183)));
residual(124)= lhs-rhs;
lhs =exp(y(8));
rhs =exp(y(4))*exp(y(31));
residual(125)= lhs-rhs;
lhs =exp(y(22));
rhs =exp(y(18))*exp(y(34));
residual(126)= lhs-rhs;
lhs =y(120);
rhs =y(119)/exp(y(8));
residual(127)= lhs-rhs;
lhs =y(121);
rhs =exp(y(8))*y(7);
residual(128)= lhs-rhs;
lhs =y(119);
rhs =exp(y(30))*(-(1-params(24)))/params(24)*y(122);
residual(129)= lhs-rhs;
lhs =y(121);
rhs =exp(y(30))*(-(1-params(24)))/params(24)*y(123);
residual(130)= lhs-rhs;
lhs =exp(y(112));
rhs =params(66)*T1096^params(67);
residual(131)= lhs-rhs;
lhs =exp(y(113))+exp(y(112))+T1109;
rhs =exp(y(78))*exp(y(80));
residual(132)= lhs-rhs;
lhs =exp(y(104));
rhs =exp(y(105))+exp(y(107));
residual(133)= lhs-rhs;
lhs =exp(y(107));
rhs =T1122*exp(y(107))^params(65)+x(5);
residual(134)= lhs-rhs;
lhs =exp(y(105));
rhs =(exp(y(8))/params(89))^(-params(195))*params(165)+y(124);
residual(135)= lhs-rhs;
lhs =y(124);
rhs =y(124)*params(64)+x(4);
residual(136)= lhs-rhs;
lhs =exp(y(104))+exp(y(32))*y(121);
rhs =exp(y(106))+y(121)*(1+y(2))*exp(y(32))/exp(y(42));
residual(137)= lhs-rhs;
lhs =exp(y(108));
rhs =exp(y(109))+exp(y(111));
residual(138)= lhs-rhs;
lhs =exp(y(111));
rhs =T1159*exp(y(111))^params(65)+x(14);
residual(139)= lhs-rhs;
lhs =exp(y(109));
rhs =(exp(y(22))/params(90))^(-params(196))*params(178)+y(125);
residual(140)= lhs-rhs;
lhs =y(125);
rhs =y(125)*params(63)+x(8);
residual(141)= lhs-rhs;
lhs =exp(y(108))+exp(y(34))*y(123);
rhs =exp(y(110))+y(123)*exp(y(34))*(1+y(16))/exp(y(52));
residual(142)= lhs-rhs;
lhs =exp(y(58));
rhs =T1190*exp(y(58))^params(18)+x(1);
residual(143)= lhs-rhs;
lhs =exp(y(59));
rhs =(1-params(19))*params(71)+exp(y(59))*params(19)+x(2);
residual(144)= lhs-rhs;
lhs =exp(y(60));
rhs =T1207*exp(y(60))^params(20)+x(3);
residual(145)= lhs-rhs;
lhs =exp(y(155));
rhs =exp(y(155))*params(304)+(1-params(304))*params(305)+x(15);
residual(146)= lhs-rhs;
lhs =y(115);
rhs =T1225*y(115)^params(21)+x(7);
residual(147)= lhs-rhs;
lhs =y(114);
rhs =y(114)*params(22)+x(6);
residual(148)= lhs-rhs;
lhs =exp(y(42));
rhs =(exp(y(1))+uuee_t__)/(exp(y(1))+uueelag__);
residual(149)= lhs-rhs;
lhs =exp(y(52));
rhs =(uuem_t__+1+exp(y(69)))/(1+exp(y(69))+uuemlag__);
residual(150)= lhs-rhs;
lhs =y(131);
rhs =y(131)*params(279)+x(11);
residual(151)= lhs-rhs;
lhs =y(132);
rhs =x(11)+y(132)*params(279)+x(12);
residual(152)= lhs-rhs;
lhs =y(154);
rhs =y(154)*params(280)+x(13);
residual(153)= lhs-rhs;
lhs =exp(y(129));
rhs =T1265*exp(y(129))^params(231)+x(9);
residual(154)= lhs-rhs;
lhs =exp(y(130));
rhs =T1274*exp(y(130))^params(233)+x(10);
residual(155)= lhs-rhs;
lhs =exp(y(156));
rhs =(exp(y(140))+exp(y(147)))/exp(y(133));
residual(156)= lhs-rhs;
lhs =y(157);
rhs =x(11);
residual(157)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(157, 157);

  %
  % Jacobian matrix
  %

T66 = params(307)/2;
T1296 = T70*T70;
T1300 = getPowerDeriv(T70/T74,(-2),1);
T1322 = (-(exp(y(114))*exp(y(5))*getPowerDeriv(exp(y(114))*exp(y(5)),(-params(13)),1)));
T1373 = getPowerDeriv(T1096,params(67),1);
T1398 = (exp(y(84))+exp(y(15))-exp(y(46)))*(exp(y(84))+exp(y(15))-exp(y(46)));
T1431 = T628*exp(y(21))*getPowerDeriv(exp(y(21)),params(52),1);
T1432 = getPowerDeriv(T631,params(51)/params(52),1);
T1435 = getPowerDeriv(T640,T642,1);
T1439 = (-(T646*(1-params(273))*exp(y(59))*params(306)*params(273)*T1431*T1432*T1435));
T1440 = getPowerDeriv(T631,1/params(52),1);
T1443 = getPowerDeriv(T631,params(51)/params(52)-1,1);
T1464 = T621*exp(y(23))*getPowerDeriv(exp(y(23)),params(52),1);
T1470 = (-(T646*(1-params(273))*exp(y(59))*params(306)*T1435*params(273)*T1432*T1464));
T1516 = getPowerDeriv(T1033,(-params(5)),1);
T1549 = exp(y(33))*getPowerDeriv(exp(y(33)),1-params(5),1);
T1553 = exp(y(33))*getPowerDeriv(exp(y(33)),params(5)-1,1);
T1660 = exp(y(38))*exp(y(134))*exp(y(137))*params(245)/(1+params(245))*(-exp(y(43)));
T1661 = exp(y(43))*params(39)+T1660;
T1760 = (-(T646*T643*params(306)*exp(y(59))*(1-params(273))*exp(y(155))));
T1762 = getPowerDeriv(T527,(-params(274)),1);
T1764 = (1-params(274))*params(131)*exp(y(60))*exp(y(58))*T520*exp(y(62))*params(131)*exp(y(60))*T1762;
T1769 = getPowerDeriv(T527,1-params(274),1);
T1772 = (-(exp(y(58))*T520*exp(y(62))*params(131)*exp(y(60))*T1769));
T1781 = exp(y(63))*getPowerDeriv(exp(y(63)),params(274),1);
T1804 = params(273)*exp(y(66))*getPowerDeriv(exp(y(66)),params(51),1);
T1805 = getPowerDeriv(T761,1/params(51),1);
T1809 = getPowerDeriv(T761,T642,1);
T1823 = T74*T74;
T1960 = exp(y(73))*params(60)+exp(y(72))*exp(y(148))*exp(y(151))*params(271)/(1+params(271))*(-exp(y(73)));
T2007 = (exp(y(85))+exp(y(83))-exp(y(82)))*(exp(y(85))+exp(y(83))-exp(y(82)));
T2089 = exp(y(87))*params(208)+exp(y(86))*exp(y(141))*exp(y(144))*params(258)/(1+params(258))*(-exp(y(87)));
T2112 = (1-params(273))*exp(y(98))*getPowerDeriv(exp(y(98)),params(51),1);
T2116 = exp(y(98))*getPowerDeriv(exp(y(98)),params(51)-1,1);
T2120 = (-(T646*(1-params(273))*exp(y(59))*params(306)*T1435*T2112+(1-params(273))*exp(y(59))*params(306)*T643*T2116));
T2137 = (-(T643*params(306)*exp(y(59))*(1-params(273))*exp(y(155))*T2116+T646*params(306)*exp(y(59))*(1-params(273))*exp(y(155))*T1435*T2112));
  g1(1,3)=exp(y(3));
  g1(1,5)=T1322;
  g1(1,114)=T1322;
  g1(2,11)=(-(params(15)*exp(y(11))*getPowerDeriv(exp(y(11)),params(14),1)));
  g1(2,64)=exp(y(64));
  g1(3,81)=exp(y(81));
  g1(3,126)=(-(params(197)*exp(y(126))*getPowerDeriv(exp(y(126)),params(14),1)));
  g1(4,1)=(-(exp(y(1))*exp(y(11))));
  g1(4,11)=(-(exp(y(1))*exp(y(11))));
  g1(4,62)=exp(y(62));
  g1(5,69)=(-(exp(y(69))*exp(y(126))));
  g1(5,80)=exp(y(80));
  g1(5,126)=(-(exp(y(69))*exp(y(126))));
  g1(6,17)=exp(y(17));
  g1(6,19)=(-(exp(y(19))*getPowerDeriv(exp(y(19)),(-params(13)),1)));
  g1(7,26)=(-(params(17)*exp(y(26))*getPowerDeriv(exp(y(26)),params(16),1)));
  g1(7,65)=exp(y(65));
  g1(8,94)=exp(y(94));
  g1(8,127)=(-(params(198)*exp(y(127))*getPowerDeriv(exp(y(127)),params(16),1)));
  g1(9,15)=(-(exp(y(26))*exp(y(15))));
  g1(9,21)=exp(y(21));
  g1(9,26)=(-(exp(y(26))*exp(y(15))));
  g1(10,83)=(-(exp(y(127))*exp(y(83))));
  g1(10,127)=(-(exp(y(127))*exp(y(83))));
  g1(10,128)=exp(y(128));
  g1(11,36)=exp(y(36));
  g1(11,38)=(-(T153*exp(y(38))*getPowerDeriv(exp(y(38)),1-params(33),1)));
  g1(11,70)=(-(T157*params(29)*exp(y(70))*getPowerDeriv(exp(y(70)),params(33),1)));
  g1(12,46)=exp(y(46));
  g1(12,48)=(-(T163*exp(y(48))*getPowerDeriv(exp(y(48)),1-params(34),1)));
  g1(12,84)=(-(T167*params(31)*exp(y(84))*getPowerDeriv(exp(y(84)),params(34),1)));
  g1(13,68)=exp(y(68));
  g1(13,71)=(-(T177*params(55)*exp(y(71))*getPowerDeriv(exp(y(71)),params(54),1)));
  g1(13,72)=(-(T173*exp(y(72))*getPowerDeriv(exp(y(72)),1-params(54),1)));
  g1(14,82)=exp(y(82));
  g1(14,85)=(-(T185*params(203)*exp(y(85))*getPowerDeriv(exp(y(85)),params(54),1)));
  g1(14,86)=(-(T182*exp(y(86))*getPowerDeriv(exp(y(86)),1-params(54),1)));
  g1(15,1)=exp(y(1))-(1-params(30))*exp(y(1));
  g1(15,36)=(-exp(y(36)));
  g1(16,15)=exp(y(15))-exp(y(15))*(1-params(32));
  g1(16,46)=(-exp(y(46)));
  g1(17,68)=(-exp(y(68)));
  g1(17,69)=exp(y(69))-(1-params(56))*exp(y(69));
  g1(18,82)=(-exp(y(82)));
  g1(18,83)=exp(y(83))-exp(y(83))*(1-params(204));
  g1(19,1)=(1-params(30))*exp(y(1));
  g1(19,37)=exp(y(37));
  g1(19,69)=(1-params(56))*exp(y(69));
  g1(20,1)=exp(y(1));
  g1(20,69)=exp(y(69));
  g1(20,100)=exp(y(100));
  g1(21,37)=(-(exp(y(37))*exp(y(103))));
  g1(21,70)=exp(y(70));
  g1(21,103)=(-(exp(y(37))*exp(y(103))));
  g1(22,37)=(-(exp(y(37))*(1-exp(y(103)))));
  g1(22,71)=exp(y(71));
  g1(22,103)=(-(exp(y(37))*(-exp(y(103)))));
  g1(23,15)=exp(y(15))*(1-params(32));
  g1(23,47)=exp(y(47));
  g1(23,83)=exp(y(83))*(1-params(204));
  g1(24,15)=exp(y(15));
  g1(24,83)=exp(y(83));
  g1(24,99)=exp(y(99));
  g1(25,15)=exp(y(15))*(1-params(32));
  g1(25,84)=exp(y(84));
  g1(26,83)=exp(y(83))*(1-params(204));
  g1(26,85)=exp(y(85));
  g1(27,68)=(-((T74*(-exp(y(68)))-(exp(y(71))-exp(y(68)))*(-exp(y(68))))/T1823));
  g1(27,69)=(-((-((exp(y(71))-exp(y(68)))*exp(y(69))))/T1823));
  g1(27,71)=(-((exp(y(71))*T74-exp(y(71))*(exp(y(71))-exp(y(68))))/T1823));
  g1(27,102)=exp(y(102));
  g1(28,1)=(-((-((exp(y(70))-exp(y(36)))*exp(y(1))))/T1296));
  g1(28,36)=(-((T70*(-exp(y(36)))-(exp(y(70))-exp(y(36)))*(-exp(y(36))))/T1296));
  g1(28,70)=(-((exp(y(70))*T70-exp(y(70))*(exp(y(70))-exp(y(36))))/T1296));
  g1(28,101)=exp(y(101));
  g1(29,15)=(-((-((exp(y(84))-exp(y(46)))*exp(y(15))))/T1398));
  g1(29,46)=(-(((exp(y(84))+exp(y(15))-exp(y(46)))*(-exp(y(46)))-(exp(y(84))-exp(y(46)))*(-exp(y(46))))/T1398));
  g1(29,84)=(-((exp(y(84))*(exp(y(84))+exp(y(15))-exp(y(46)))-exp(y(84))*(exp(y(84))-exp(y(46))))/T1398));
  g1(29,95)=exp(y(95));
  g1(30,82)=(-(((exp(y(85))+exp(y(83))-exp(y(82)))*(-exp(y(82)))-(exp(y(85))-exp(y(82)))*(-exp(y(82))))/T2007));
  g1(30,83)=(-((-((exp(y(85))-exp(y(82)))*exp(y(83))))/T2007));
  g1(30,85)=(-((exp(y(85))*(exp(y(85))+exp(y(83))-exp(y(82)))-exp(y(85))*(exp(y(85))-exp(y(82))))/T2007));
  g1(30,96)=exp(y(96));
  g1(31,1)=T66*exp(y(1))/T74*T1300;
  g1(31,10)=exp(y(44))*(exp(y(10))+params(1)*exp(y(10))*(1-params(30)))+(1-exp(y(44)))*params(1)*exp(y(10))*exp(y(44));
  g1(31,36)=T66*T1300*(-exp(y(36)))/T74;
  g1(31,44)=exp(y(44))*WE_t__+UE_t__*(-exp(y(44)))+(1-exp(y(44)))*params(1)*(exp(y(10))*exp(y(44))+params(185)*(-exp(y(44))));
  g1(31,68)=T66*T1300*(-(T70*(-exp(y(68)))))/T1823;
  g1(31,69)=T66*T1300*(-(T70*exp(y(69))))/T1823;
  g1(31,70)=T66*T1300*exp(y(70))/T74;
  g1(31,71)=T66*T1300*(-(exp(y(71))*T70))/T1823;
  g1(31,74)=(-(exp(y(154))*(exp(y(74))*WM_t__+UM_t__*(-exp(y(74)))+(1-exp(y(74)))*params(1)*(exp(y(78))*exp(y(74))+params(186)*(-exp(y(74)))))));
  g1(31,78)=(-(exp(y(154))*(exp(y(74))*(exp(y(78))+params(1)*exp(y(78))*(1-params(56)))+(1-exp(y(74)))*params(1)*exp(y(78))*exp(y(74)))));
  g1(31,154)=(-(exp(y(154))*(exp(y(74))*WM_t__+(1-exp(y(74)))*UM_t__)));
  g1(32,36)=(-(exp(y(36))/exp(y(38))));
  g1(32,38)=(-((-(exp(y(36))*exp(y(38))))/(exp(y(38))*exp(y(38)))));
  g1(32,43)=exp(y(43));
  g1(33,46)=(-(exp(y(46))/exp(y(48))));
  g1(33,48)=(-((-(exp(y(46))*exp(y(48))))/(exp(y(48))*exp(y(48)))));
  g1(33,53)=exp(y(53));
  g1(34,68)=(-(exp(y(68))/exp(y(72))));
  g1(34,72)=(-((-(exp(y(68))*exp(y(72))))/(exp(y(72))*exp(y(72)))));
  g1(34,73)=exp(y(73));
  g1(35,82)=(-(exp(y(82))/exp(y(86))));
  g1(35,86)=(-((-(exp(y(82))*exp(y(86))))/(exp(y(86))*exp(y(86)))));
  g1(35,87)=exp(y(87));
  g1(36,36)=(-(exp(y(36))/exp(y(70))));
  g1(36,44)=exp(y(44));
  g1(36,70)=(-((-(exp(y(70))*exp(y(36))))/(exp(y(70))*exp(y(70)))));
  g1(37,68)=(-(exp(y(68))/exp(y(71))));
  g1(37,71)=(-((-(exp(y(71))*exp(y(68))))/(exp(y(71))*exp(y(71)))));
  g1(37,74)=exp(y(74));
  g1(38,46)=(-(exp(y(46))/exp(y(84))));
  g1(38,54)=exp(y(54));
  g1(38,84)=(-((-(exp(y(84))*exp(y(46))))/(exp(y(84))*exp(y(84)))));
  g1(39,82)=(-(exp(y(82))/exp(y(85))));
  g1(39,85)=(-((-(exp(y(85))*exp(y(82))))/(exp(y(85))*exp(y(85)))));
  g1(39,88)=exp(y(88));
  g1(40,38)=(-(exp(y(38))/exp(y(70))));
  g1(40,70)=(-((-(exp(y(70))*exp(y(38))))/(exp(y(70))*exp(y(70)))));
  g1(40,116)=exp(y(116));
  g1(41,48)=(-(exp(y(48))/exp(y(84))));
  g1(41,84)=(-((-(exp(y(84))*exp(y(48))))/(exp(y(84))*exp(y(84)))));
  g1(41,117)=exp(y(117));
  g1(42,71)=(-((-(exp(y(71))*exp(y(72))))/(exp(y(71))*exp(y(71)))));
  g1(42,72)=(-(exp(y(72))/exp(y(71))));
  g1(42,118)=exp(y(118));
  g1(43,85)=(-((-(exp(y(85))*exp(y(86))))/(exp(y(85))*exp(y(85)))));
  g1(43,86)=(-(exp(y(86))/exp(y(85))));
  g1(43,97)=exp(y(97));
  g1(44,50)=exp(y(50));
  g1(44,51)=(-((1-params(36))/params(36)*exp(y(51))));
  g1(45,40)=exp(y(40));
  g1(45,41)=(-((1-params(35))/params(35)*exp(y(41))));
  g1(46,76)=(-((1-params(57))/params(57)*exp(y(76))));
  g1(46,77)=exp(y(77));
  g1(47,90)=(-((1-params(205))/params(205)*exp(y(90))));
  g1(47,91)=exp(y(91));
  g1(48,25)=(-(exp(y(26))*(-exp(y(25)))));
  g1(48,26)=(-(exp(y(26))*(exp(y(65))-exp(y(25)))));
  g1(48,50)=exp(y(50))-T361;
  g1(48,65)=(-(exp(y(65))*exp(y(26))));
  g1(49,10)=(-(exp(y(10))*exp(y(11))));
  g1(49,11)=(-(exp(y(10))*exp(y(11))+(-params(15))/(1+params(14))*exp(y(11))*getPowerDeriv(exp(y(11)),1+params(14),1)));
  g1(49,41)=exp(y(41))-(1-params(30))*(1-exp(y(44)))*exp(y(41))*T373;
  g1(49,44)=(-((1-params(30))*exp(y(41))*T373*(-exp(y(44)))));
  g1(50,25)=(-(exp(y(26))*exp(y(25))));
  g1(50,26)=(-(exp(y(26))*exp(y(25))+(-params(17))/(1+params(16))*exp(y(26))*getPowerDeriv(exp(y(26)),1+params(16),1)));
  g1(50,51)=exp(y(51))-(1-params(32))*exp(y(51))*T389*(1-exp(y(54)));
  g1(50,54)=(-((1-params(32))*exp(y(51))*T389*(-exp(y(54)))));
  g1(51,74)=(-((1-params(56))*exp(y(76))*T373*(-exp(y(74)))));
  g1(51,76)=exp(y(76))-(1-params(56))*(1-exp(y(74)))*exp(y(76))*T373;
  g1(51,78)=(-(exp(y(78))*exp(y(126))));
  g1(51,126)=(-(exp(y(78))*exp(y(126))+(-params(197))/(1+params(14))*exp(y(126))*getPowerDeriv(exp(y(126)),1+params(14),1)));
  g1(52,88)=(-((1-params(204))*exp(y(90))*T389*(-exp(y(88)))));
  g1(52,90)=exp(y(90))-(1-params(204))*exp(y(90))*T389*(1-exp(y(88)));
  g1(52,92)=(-(exp(y(127))*exp(y(92))));
  g1(52,127)=(-(exp(y(127))*exp(y(92))+(-params(198))/(1+params(16))*exp(y(127))*getPowerDeriv(exp(y(127)),1+params(16),1)));
  g1(53,50)=exp(y(53))*exp(y(50));
  g1(53,53)=exp(y(53))*(exp(y(50))-params(41));
  g1(53,56)=(-1);
  g1(53,57)=(-T389);
  g1(54,10)=(-(exp(y(11))*(-exp(y(10)))));
  g1(54,11)=(-(exp(y(11))*(exp(y(64))-exp(y(10)))));
  g1(54,40)=exp(y(40))-T373*(1-params(30))*exp(y(40));
  g1(54,64)=(-(exp(y(64))*exp(y(11))));
  g1(54,139)=(-(T373*params(30)*exp(y(139))));
  g1(55,40)=(-(exp(y(43))*exp(y(40))));
  g1(55,43)=(-(exp(y(43))*exp(y(40))+(exp(y(139))*(1-exp(y(137)))+exp(y(137))*exp(y(138)))*T373*(-exp(y(43)))));
  g1(55,137)=(-(T373*(1-exp(y(43)))*(exp(y(137))*exp(y(138))+exp(y(139))*(-exp(y(137))))));
  g1(55,138)=(-(T373*(1-exp(y(43)))*exp(y(137))*exp(y(138))));
  g1(55,139)=exp(y(139))-T373*(1-exp(y(43)))*exp(y(139))*(1-exp(y(137)));
  g1(56,38)=(-(exp(y(38))*(1-exp(y(43)))*exp(y(137))));
  g1(56,42)=(-(exp(y(129))*(-(exp(y(133))*(1-params(244))*exp(y(42))))/(exp(y(42))*exp(y(42)))));
  g1(56,43)=(-(exp(y(38))*exp(y(137))*(-exp(y(43)))));
  g1(56,129)=(-T469);
  g1(56,133)=exp(y(133))-T469;
  g1(56,137)=(-(exp(y(38))*(1-exp(y(43)))*exp(y(137))));
  g1(57,1)=(-(params(30)*exp(y(1))));
  g1(57,38)=exp(y(38))-(1-exp(y(137)))*exp(y(38))*(1-exp(y(43)));
  g1(57,43)=(-((1-exp(y(137)))*exp(y(38))*(-exp(y(43)))));
  g1(57,135)=(-exp(y(135)));
  g1(57,137)=(-(exp(y(38))*(1-exp(y(43)))*(-exp(y(137)))));
  g1(58,134)=exp(y(134));
  g1(58,138)=(-exp(y(138)));
  g1(58,139)=exp(y(139));
  g1(59,134)=(-(exp(y(134))/params(242)*getPowerDeriv(exp(y(134))/params(242),params(245),1)));
  g1(59,137)=exp(y(137));
  g1(60,135)=exp(y(135));
  g1(60,139)=(-(exp(y(139))/params(241)*getPowerDeriv(exp(y(139))/params(241),params(246),1)));
  g1(61,136)=(-exp(y(136)));
  g1(61,138)=exp(y(138))-T503;
  g1(62,39)=exp(y(39));
  g1(62,58)=(-((1-params(274))*params(131)*exp(y(60))*exp(y(58))*T520*T529));
  g1(62,60)=(-((1-params(274))*params(131)*exp(y(60))*exp(y(58))*T520*T529+T1764));
  g1(62,62)=(-T1764);
  g1(62,63)=(-(T529*(1-params(274))*params(131)*exp(y(60))*exp(y(58))*T1781));
  g1(62,132)=(-((1-params(274))*params(131)*exp(y(60))*exp(y(58))*T520*exp(y(133))*exp(y(132))*T1762));
  g1(62,133)=(-((1-params(274))*params(131)*exp(y(60))*exp(y(58))*T520*exp(y(133))*exp(y(132))*T1762));
  g1(63,58)=(-(T529*T520*exp(y(58))*(1-params(274))*exp(y(132))));
  g1(63,60)=(-(T520*exp(y(58))*(1-params(274))*exp(y(132))*exp(y(62))*params(131)*exp(y(60))*T1762));
  g1(63,62)=(-(T520*exp(y(58))*(1-params(274))*exp(y(132))*exp(y(62))*params(131)*exp(y(60))*T1762));
  g1(63,63)=(-(T529*exp(y(58))*(1-params(274))*exp(y(132))*T1781));
  g1(63,132)=(-(T529*T520*exp(y(58))*(1-params(274))*exp(y(132))+T520*exp(y(58))*(1-params(274))*exp(y(132))*exp(y(133))*exp(y(132))*T1762));
  g1(63,133)=(-(T520*exp(y(58))*(1-params(274))*exp(y(132))*exp(y(133))*exp(y(132))*T1762));
  g1(63,136)=exp(y(136));
  g1(64,91)=exp(y(91))-T389*(1-params(204))*exp(y(91));
  g1(64,92)=(-(exp(y(127))*(-exp(y(92)))));
  g1(64,94)=(-(exp(y(94))*exp(y(127))));
  g1(64,127)=(-(exp(y(127))*(exp(y(94))-exp(y(92)))));
  g1(64,146)=(-(T389*params(204)*exp(y(146))));
  g1(65,87)=(-(exp(y(87))*exp(y(91))+(exp(y(146))*(1-exp(y(144)))+exp(y(144))*exp(y(145)))*T389*(-exp(y(87)))));
  g1(65,91)=(-(exp(y(87))*exp(y(91))));
  g1(65,144)=(-(T389*(1-exp(y(87)))*(exp(y(144))*exp(y(145))+exp(y(146))*(-exp(y(144))))));
  g1(65,145)=(-(T389*(1-exp(y(87)))*exp(y(144))*exp(y(145))));
  g1(65,146)=exp(y(146))-T389*(1-exp(y(87)))*exp(y(146))*(1-exp(y(144)));
  g1(66,52)=(-((-(exp(y(140))*exp(y(130))*(1-params(257))*exp(y(52))))/(exp(y(52))*exp(y(52)))));
  g1(66,86)=(-(exp(y(86))*(1-exp(y(87)))*exp(y(144))));
  g1(66,87)=(-(exp(y(86))*exp(y(144))*(-exp(y(87)))));
  g1(66,130)=(-T574);
  g1(66,140)=exp(y(140))-T574;
  g1(66,144)=(-(exp(y(86))*(1-exp(y(87)))*exp(y(144))));
  g1(67,83)=(-(exp(y(83))*params(204)));
  g1(67,86)=exp(y(86))-(1-exp(y(144)))*exp(y(86))*(1-exp(y(87)));
  g1(67,87)=(-((1-exp(y(144)))*exp(y(86))*(-exp(y(87)))));
  g1(67,142)=(-exp(y(142)));
  g1(67,144)=(-(exp(y(86))*(1-exp(y(87)))*(-exp(y(144)))));
  g1(68,141)=exp(y(141));
  g1(68,145)=(-exp(y(145)));
  g1(68,146)=exp(y(146));
  g1(69,141)=(-(exp(y(141))/params(255)*getPowerDeriv(exp(y(141))/params(255),params(258),1)));
  g1(69,144)=exp(y(144));
  g1(70,142)=exp(y(142));
  g1(70,146)=(-(exp(y(146))/params(254)*getPowerDeriv(exp(y(146))/params(254),params(259),1)));
  g1(71,143)=(-exp(y(143)));
  g1(71,145)=exp(y(145))-T608;
  g1(72,21)=T1439;
  g1(72,23)=T1470;
  g1(72,59)=(-T647);
  g1(72,98)=T2120;
  g1(72,143)=exp(y(143));
  g1(73,77)=exp(y(77))-T389*(1-params(56))*exp(y(77));
  g1(73,78)=(-(exp(y(126))*(-exp(y(78)))));
  g1(73,81)=(-(exp(y(81))*exp(y(126))));
  g1(73,126)=(-(exp(y(126))*(exp(y(81))-exp(y(78)))));
  g1(73,153)=(-(T389*params(56)*exp(y(153))));
  g1(74,73)=(-(exp(y(73))*exp(y(77))+(exp(y(153))*(1-exp(y(151)))+exp(y(151))*exp(y(152)))*T389*(-exp(y(73)))));
  g1(74,77)=(-(exp(y(73))*exp(y(77))));
  g1(74,151)=(-(T389*(1-exp(y(73)))*(exp(y(151))*exp(y(152))+exp(y(153))*(-exp(y(151))))));
  g1(74,152)=(-(T389*(1-exp(y(73)))*exp(y(151))*exp(y(152))));
  g1(74,153)=exp(y(153))-T389*(1-exp(y(73)))*exp(y(153))*(1-exp(y(151)));
  g1(75,52)=(-((-(exp(y(52))*exp(y(147))*exp(y(130))*(1-params(270))))/(exp(y(52))*exp(y(52)))));
  g1(75,72)=(-(exp(y(72))*(1-exp(y(73)))*exp(y(151))));
  g1(75,73)=(-(exp(y(72))*exp(y(151))*(-exp(y(73)))));
  g1(75,130)=(-T682);
  g1(75,147)=exp(y(147))-T682;
  g1(75,151)=(-(exp(y(72))*(1-exp(y(73)))*exp(y(151))));
  g1(76,69)=(-(params(56)*exp(y(69))));
  g1(76,72)=exp(y(72))-(1-exp(y(151)))*exp(y(72))*(1-exp(y(73)));
  g1(76,73)=(-((1-exp(y(151)))*exp(y(72))*(-exp(y(73)))));
  g1(76,149)=(-exp(y(149)));
  g1(76,151)=(-(exp(y(72))*(1-exp(y(73)))*(-exp(y(151)))));
  g1(77,148)=exp(y(148));
  g1(77,152)=(-exp(y(152)));
  g1(77,153)=exp(y(153));
  g1(78,148)=(-(exp(y(148))/params(268)*getPowerDeriv(exp(y(148))/params(268),params(271),1)));
  g1(78,151)=exp(y(151));
  g1(79,149)=exp(y(149));
  g1(79,153)=(-(exp(y(153))/params(267)*getPowerDeriv(exp(y(153))/params(267),params(272),1)));
  g1(80,150)=(-exp(y(150)));
  g1(80,152)=exp(y(152))-T716;
  g1(81,21)=T1439;
  g1(81,23)=T1470;
  g1(81,59)=(-T647);
  g1(81,98)=T2120;
  g1(81,150)=exp(y(150));
  g1(82,4)=exp(y(4));
  g1(82,58)=(-(exp(y(58))*T520*T723));
  g1(82,60)=T1772;
  g1(82,62)=T1772;
  g1(82,63)=(-(T723*exp(y(58))*T1781));
  g1(82,132)=(-(exp(y(58))*T520*exp(y(133))*exp(y(132))*T1769));
  g1(82,133)=(-(exp(y(58))*T520*exp(y(133))*exp(y(132))*T1769));
  g1(83,12)=(-1);
  g1(83,42)=(-((-(exp(y(42))*exp(y(63))*(1-params(9))))/(exp(y(42))*exp(y(42)))));
  g1(83,63)=exp(y(63))-exp(y(63))*(1-params(9))/exp(y(42));
  g1(84,9)=exp(y(9))-T373*(1-params(9))*exp(y(9))/exp(y(42));
  g1(84,31)=(-(T373*exp(y(31))*exp(y(61))));
  g1(84,42)=(-(T373*(-(exp(y(42))*(1-params(9))*exp(y(9))))/(exp(y(42))*exp(y(42)))));
  g1(84,61)=(-(T373*exp(y(31))*exp(y(61))));
  g1(85,9)=(-(exp(y(9))*y(13)+params(1)*exp(y(9))*y(14)));
  g1(85,13)=(-exp(y(9)));
  g1(85,14)=(-(params(1)*exp(y(9))));
  g1(86,31)=(-(exp(y(39))*exp(y(31))));
  g1(86,39)=(-(exp(y(39))*exp(y(31))));
  g1(86,64)=exp(y(64));
  g1(87,18)=exp(y(18));
  g1(87,59)=(-T763);
  g1(87,66)=(-(exp(y(59))*params(306)*T1804*T1805));
  g1(87,98)=(-(exp(y(59))*params(306)*T1805*T2112));
  g1(88,21)=(-(T1431*T1440));
  g1(88,23)=(-(T1440*T1464));
  g1(88,66)=exp(y(66));
  g1(89,23)=exp(y(23))-exp(y(23))*(1-params(10))/exp(y(52));
  g1(89,27)=(-1);
  g1(89,52)=(-((-(exp(y(52))*exp(y(23))*(1-params(10))))/(exp(y(52))*exp(y(52)))));
  g1(90,24)=exp(y(24))-T389*(1-params(10))*exp(y(24))/exp(y(52));
  g1(90,34)=(-(T389*exp(y(34))*exp(y(67))));
  g1(90,52)=(-(T389*(-(exp(y(52))*(1-params(10))*exp(y(24))))/(exp(y(52))*exp(y(52)))));
  g1(90,67)=(-(T389*exp(y(34))*exp(y(67))));
  g1(91,24)=(-(exp(y(24))*y(28)+params(2)*exp(y(24))*y(29)));
  g1(91,28)=(-exp(y(24)));
  g1(91,29)=(-(params(2)*exp(y(24))));
  g1(92,21)=(-(T803*params(306)*exp(y(59))*params(273)*T621*T797*T1431*T1443));
  g1(92,23)=(-(T803*params(306)*exp(y(59))*params(273)*T621*T797*T1443*T1464+params(306)*exp(y(59))*params(273)*T621*T797*T800*exp(y(23))*getPowerDeriv(exp(y(23)),params(52)-1,1)));
  g1(92,59)=(-(params(306)*exp(y(59))*params(273)*T621*T797*T800*T803));
  g1(92,66)=(-(T803*T800*params(306)*exp(y(59))*params(273)*T621*T1804*T1809));
  g1(92,67)=exp(y(67));
  g1(92,98)=(-(T803*T800*params(306)*exp(y(59))*params(273)*T621*T1809*T2112));
  g1(93,21)=(-(T813*T797*params(306)*exp(y(59))*params(273)*T628*T1431*T1443+T800*T797*params(306)*exp(y(59))*params(273)*T628*exp(y(21))*getPowerDeriv(exp(y(21)),params(52)-1,1)));
  g1(93,23)=(-(T813*T797*params(306)*exp(y(59))*params(273)*T628*T1443*T1464));
  g1(93,49)=exp(y(49));
  g1(93,59)=(-(T800*T797*params(306)*exp(y(59))*params(273)*T628*T813));
  g1(93,66)=(-(T813*T800*params(306)*exp(y(59))*params(273)*T628*T1804*T1809));
  g1(93,98)=(-(T813*T800*params(306)*exp(y(59))*params(273)*T628*T1809*T2112));
  g1(94,21)=(-(T646*params(306)*exp(y(59))*(1-params(273))*exp(y(155))*params(273)*T1431*T1432*T1435));
  g1(94,23)=(-(T646*params(306)*exp(y(59))*(1-params(273))*exp(y(155))*T1435*params(273)*T1432*T1464));
  g1(94,59)=T1760;
  g1(94,79)=exp(y(79));
  g1(94,98)=T2137;
  g1(94,155)=T1760;
  g1(95,21)=(-(T646*params(306)*exp(y(59))*(1-params(273))*exp(y(155))*params(273)*T1431*T1432*T1435));
  g1(95,23)=(-(T646*params(306)*exp(y(59))*(1-params(273))*exp(y(155))*T1435*params(273)*T1432*T1464));
  g1(95,59)=T1760;
  g1(95,93)=exp(y(93));
  g1(95,98)=T2137;
  g1(95,155)=T1760;
  g1(96,34)=exp(y(34))*exp(y(49));
  g1(96,49)=exp(y(34))*exp(y(49));
  g1(96,65)=(-exp(y(65)));
  g1(97,34)=exp(y(34))*exp(y(79));
  g1(97,79)=exp(y(34))*exp(y(79));
  g1(97,81)=(-exp(y(81)));
  g1(98,34)=exp(y(34))*exp(y(93));
  g1(98,93)=exp(y(34))*exp(y(93));
  g1(98,94)=(-exp(y(94)));
  g1(99,80)=(-(exp(y(80))*exp(y(155))));
  g1(99,98)=exp(y(98));
  g1(99,128)=(-(exp(y(128))*exp(y(155))));
  g1(99,131)=(-(exp(y(140))*exp(y(131))+exp(y(147))*exp(y(131))));
  g1(99,140)=(-(exp(y(140))*exp(y(131))));
  g1(99,147)=(-(exp(y(147))*exp(y(131))));
  g1(99,155)=(-(exp(y(80))*exp(y(155))+exp(y(128))*exp(y(155))));
  g1(100,6)=(-(params(11)*exp(y(6))));
  g1(100,12)=1;
  g1(101,6)=(-((-(y(12)*exp(y(6))))/(exp(y(6))*exp(y(6)))));
  g1(101,12)=(-(1/exp(y(6))));
  g1(101,13)=1;
  g1(102,14)=1;
  g1(103,20)=(-(params(11)*exp(y(20))));
  g1(103,27)=1;
  g1(104,20)=(-((-(y(27)*exp(y(20))))/(exp(y(20))*exp(y(20)))));
  g1(104,27)=(-(1/exp(y(20))));
  g1(104,28)=1;
  g1(105,29)=1;
  g1(106,38)=(-(exp(y(38))*params(40)));
  g1(106,45)=1;
  g1(107,48)=(-(exp(y(48))*params(42)));
  g1(107,55)=1;
  g1(108,48)=(-((-(exp(y(48))*y(55)))/(exp(y(48))*exp(y(48)))));
  g1(108,55)=(-(1/exp(y(48))));
  g1(108,56)=1;
  g1(109,57)=1;
  g1(110,72)=(-(exp(y(72))*params(59)));
  g1(110,75)=1;
  g1(111,86)=(-(exp(y(86))*params(207)));
  g1(111,89)=1;
  g1(112,58)=(-T897);
  g1(112,60)=(-(T896*exp(y(62))*params(131)*exp(y(60))*T1769));
  g1(112,61)=exp(y(61));
  g1(112,62)=(-(T896*exp(y(62))*params(131)*exp(y(60))*T1769));
  g1(112,63)=(-(T723*params(274)*exp(y(58))*exp(y(63))*getPowerDeriv(exp(y(63)),params(274)-1,1)));
  g1(112,132)=(-(T896*exp(y(133))*exp(y(132))*T1769));
  g1(112,133)=(-(T896*exp(y(133))*exp(y(132))*T1769));
  g1(113,2)=(-1)/((1+y(2))*(1+y(2)));
  g1(113,42)=(-(T373*exp(y(32))/exp(y(32))*(-exp(y(42)))/(exp(y(42))*exp(y(42)))));
  g1(114,16)=(-1)/((1+y(16))*(1+y(16)));
  g1(114,52)=(-(T389*exp(y(34))/exp(y(34))*(-exp(y(52)))/(exp(y(52))*exp(y(52)))));
  g1(115,31)=exp(y(31))*getPowerDeriv(exp(y(31)),params(5)-1,1);
  g1(115,33)=(-((1-params(3))*T1549));
  g1(116,32)=exp(y(32))*getPowerDeriv(exp(y(32)),params(5)-1,1);
  g1(116,33)=(-(params(3)*T1553));
  g1(117,30)=exp(y(30))*getPowerDeriv(exp(y(30)),1-params(5),1);
  g1(117,33)=(-(((params(3)+(1-params(3))*T925)*(1-params(4))*T1549-(params(4)+T925*(1-params(4)))*(1-params(3))*T1549)/((params(3)+(1-params(3))*T925)*(params(3)+(1-params(3))*T925))));
  g1(118,33)=(-((1-params(4))*T1549));
  g1(118,35)=exp(y(35))*getPowerDeriv(exp(y(35)),params(5)-1,1);
  g1(119,33)=(-(params(4)*T1553));
  g1(119,34)=exp(y(34))*getPowerDeriv(exp(y(34)),params(5)-1,1);
  g1(120,5)=(-(exp(y(5))*T955));
  g1(120,6)=(-(exp(y(6))*T955));
  g1(120,8)=exp(y(8));
  g1(120,19)=(-(exp(y(19))*T983));
  g1(120,20)=(-(exp(y(20))*T983));
  g1(120,31)=(-(T976*params(3)*exp(y(31))*getPowerDeriv(exp(y(31)),(-params(5)),1)));
  g1(120,35)=(-(T1027*params(4)*(1-params(24))/params(24)*exp(y(35))*getPowerDeriv(exp(y(35)),(-params(5)),1)));
  g1(120,38)=(-(T955*T970));
  g1(120,43)=(-(T955*T1661));
  g1(120,45)=(-T955);
  g1(120,53)=(-(T983*exp(y(53))*params(41)));
  g1(120,55)=(-T983);
  g1(120,72)=(-(T983*T1007));
  g1(120,73)=(-(T983*T1960));
  g1(120,75)=(-T983);
  g1(120,86)=(-(T983*T1021));
  g1(120,87)=(-(T983*T2089));
  g1(120,89)=(-T983);
  g1(120,104)=(-(T955*exp(y(104))));
  g1(120,108)=(-(T983*exp(y(108))));
  g1(120,113)=(-(T983*exp(y(113))));
  g1(120,133)=(-(T955*exp(y(133))*params(243)));
  g1(120,134)=(-(T955*T970));
  g1(120,135)=(-(T955*T975));
  g1(120,137)=(-(T955*T970));
  g1(120,139)=(-(T955*T975));
  g1(120,140)=(-(T983*exp(y(140))*params(256)));
  g1(120,141)=(-(T983*T1021));
  g1(120,142)=(-(T983*T1026));
  g1(120,144)=(-(T983*T1021));
  g1(120,146)=(-(T983*T1026));
  g1(120,147)=(-(T983*exp(y(147))*params(269)));
  g1(120,148)=(-(T983*T1007));
  g1(120,149)=(-(T983*T1012));
  g1(120,151)=(-(T983*T1007));
  g1(120,153)=(-(T983*T1012));
  g1(121,5)=(-(exp(y(5))*T1040));
  g1(121,6)=(-(exp(y(6))*T1040));
  g1(121,19)=(-(exp(y(19))*T1035));
  g1(121,20)=(-(exp(y(20))*T1035));
  g1(121,22)=exp(y(22));
  g1(121,30)=(-(T1027*(1-params(4))*(-(exp(y(32))*exp(y(30))))/(exp(y(30))*exp(y(30)))*T1516));
  g1(121,32)=(-(T1027*(1-params(4))*T1033*T1516+T976*(1-params(3))*params(24)/(1-params(24))*exp(y(32))*getPowerDeriv(exp(y(32)),(-params(5)),1)));
  g1(121,38)=(-(T970*T1040));
  g1(121,43)=(-(T1040*T1661));
  g1(121,45)=(-T1040);
  g1(121,53)=(-(exp(y(53))*params(41)*T1035));
  g1(121,55)=(-T1035);
  g1(121,72)=(-(T1007*T1035));
  g1(121,73)=(-(T1035*T1960));
  g1(121,75)=(-T1035);
  g1(121,86)=(-(T1021*T1035));
  g1(121,87)=(-(T1035*T2089));
  g1(121,89)=(-T1035);
  g1(121,104)=(-(exp(y(104))*T1040));
  g1(121,108)=(-(exp(y(108))*T1035));
  g1(121,113)=(-(exp(y(113))*T1035));
  g1(121,133)=(-(exp(y(133))*params(243)*T1040));
  g1(121,134)=(-(T970*T1040));
  g1(121,135)=(-(T975*T1040));
  g1(121,137)=(-(T970*T1040));
  g1(121,139)=(-(T975*T1040));
  g1(121,140)=(-(exp(y(140))*params(256)*T1035));
  g1(121,141)=(-(T1021*T1035));
  g1(121,142)=(-(T1026*T1035));
  g1(121,144)=(-(T1021*T1035));
  g1(121,146)=(-(T1026*T1035));
  g1(121,147)=(-(exp(y(147))*params(269)*T1035));
  g1(121,148)=(-(T1007*T1035));
  g1(121,149)=(-(T1012*T1035));
  g1(121,151)=(-(T1007*T1035));
  g1(121,153)=(-(T1012*T1035));
  g1(122,5)=exp(y(5));
  g1(122,6)=exp(y(6));
  g1(122,8)=(-exp(y(8)));
  g1(122,38)=T970;
  g1(122,43)=(-((-(exp(y(43))*params(39)))-T1660));
  g1(122,45)=1;
  g1(122,104)=exp(y(104));
  g1(122,119)=1;
  g1(122,133)=exp(y(133))*params(243);
  g1(122,134)=T970;
  g1(122,135)=T975;
  g1(122,137)=T970;
  g1(122,139)=T975;
  g1(123,2)=(-(y(7)/exp(y(42))));
  g1(123,7)=1-T1058/exp(y(42));
  g1(123,42)=(-((-(exp(y(42))*y(7)*T1058))/(exp(y(42))*exp(y(42)))));
  g1(123,120)=(-1);
  g1(124,2)=1;
  g1(124,7)=(-((1+y(16)+y(115))*(-params(7))*exp((-params(7))*(y(7)-params(183)))));
  g1(124,16)=(-exp((-params(7))*(y(7)-params(183))));
  g1(124,115)=(-exp((-params(7))*(y(7)-params(183))));
  g1(125,4)=(-(exp(y(4))*exp(y(31))));
  g1(125,8)=exp(y(8));
  g1(125,31)=(-(exp(y(4))*exp(y(31))));
  g1(126,18)=(-(exp(y(18))*exp(y(34))));
  g1(126,22)=exp(y(22));
  g1(126,34)=(-(exp(y(18))*exp(y(34))));
  g1(127,8)=(-((-(exp(y(8))*y(119)))/(exp(y(8))*exp(y(8)))));
  g1(127,119)=(-(1/exp(y(8))));
  g1(127,120)=1;
  g1(128,7)=(-exp(y(8)));
  g1(128,8)=(-(exp(y(8))*y(7)));
  g1(128,121)=1;
  g1(129,30)=(-(exp(y(30))*(-(1-params(24)))/params(24)*y(122)));
  g1(129,119)=1;
  g1(129,122)=(-(exp(y(30))*(-(1-params(24)))/params(24)));
  g1(130,30)=(-(exp(y(30))*(-(1-params(24)))/params(24)*y(123)));
  g1(130,121)=1;
  g1(130,123)=(-(exp(y(30))*(-(1-params(24)))/params(24)));
  g1(131,10)=(-(params(66)*(-(exp(y(10))*exp(y(78))))/(exp(y(10))*exp(y(10)))*T1373));
  g1(131,78)=(-(params(66)*T1096*T1373));
  g1(131,112)=exp(y(112));
  g1(132,68)=((uuem_t__+1+exp(y(69)))*exp(y(110))*(-exp(y(68)))-exp(y(110))*(exp(y(69))+uuem_t__)*(-exp(y(68))))/((uuem_t__+1+exp(y(69)))*(uuem_t__+1+exp(y(69))));
  g1(132,69)=((uuem_t__+1+exp(y(69)))*exp(y(69))*exp(y(110))-exp(y(69))*exp(y(110))*(exp(y(69))+uuem_t__))/((uuem_t__+1+exp(y(69)))*(uuem_t__+1+exp(y(69))));
  g1(132,71)=((uuem_t__+1+exp(y(69)))*exp(y(71))*exp(y(110))-exp(y(71))*exp(y(110))*(exp(y(69))+uuem_t__))/((uuem_t__+1+exp(y(69)))*(uuem_t__+1+exp(y(69))));
  g1(132,78)=(-(exp(y(78))*exp(y(80))));
  g1(132,80)=(-(exp(y(78))*exp(y(80))));
  g1(132,110)=T1109;
  g1(132,112)=exp(y(112));
  g1(132,113)=exp(y(113));
  g1(133,104)=exp(y(104));
  g1(133,105)=(-exp(y(105)));
  g1(133,107)=(-exp(y(107)));
  g1(134,107)=exp(y(107))-T1122*exp(y(107))*getPowerDeriv(exp(y(107)),params(65),1);
  g1(135,8)=(-(params(165)*exp(y(8))/params(89)*getPowerDeriv(exp(y(8))/params(89),(-params(195)),1)));
  g1(135,105)=exp(y(105));
  g1(135,124)=(-1);
  g1(136,124)=1-params(64);
  g1(137,2)=(-(exp(y(32))*y(121)/exp(y(42))));
  g1(137,32)=exp(y(32))*y(121)-y(121)*(1+y(2))*exp(y(32))/exp(y(42));
  g1(137,42)=(-((-(exp(y(42))*y(121)*(1+y(2))*exp(y(32))))/(exp(y(42))*exp(y(42)))));
  g1(137,104)=exp(y(104));
  g1(137,106)=(-exp(y(106)));
  g1(137,121)=exp(y(32))-(1+y(2))*exp(y(32))/exp(y(42));
  g1(138,108)=exp(y(108));
  g1(138,109)=(-exp(y(109)));
  g1(138,111)=(-exp(y(111)));
  g1(139,111)=exp(y(111))-T1159*exp(y(111))*getPowerDeriv(exp(y(111)),params(65),1);
  g1(140,22)=(-(params(178)*exp(y(22))/params(90)*getPowerDeriv(exp(y(22))/params(90),(-params(196)),1)));
  g1(140,109)=exp(y(109));
  g1(140,125)=(-1);
  g1(141,125)=1-params(63);
  g1(142,16)=(-(exp(y(34))*y(123)/exp(y(52))));
  g1(142,34)=exp(y(34))*y(123)-y(123)*exp(y(34))*(1+y(16))/exp(y(52));
  g1(142,52)=(-((-(exp(y(52))*y(123)*exp(y(34))*(1+y(16))))/(exp(y(52))*exp(y(52)))));
  g1(142,108)=exp(y(108));
  g1(142,110)=(-exp(y(110)));
  g1(142,123)=exp(y(34))-exp(y(34))*(1+y(16))/exp(y(52));
  g1(143,58)=exp(y(58))-T1190*exp(y(58))*getPowerDeriv(exp(y(58)),params(18),1);
  g1(144,59)=exp(y(59))-exp(y(59))*params(19);
  g1(145,60)=exp(y(60))-T1207*exp(y(60))*getPowerDeriv(exp(y(60)),params(20),1);
  g1(146,155)=exp(y(155))-exp(y(155))*params(304);
  g1(147,115)=1-T1225*getPowerDeriv(y(115),params(21),1);
  g1(148,114)=1-params(22);
  g1(149,1)=(-((exp(y(1))*(exp(y(1))+uueelag__)-exp(y(1))*(exp(y(1))+uuee_t__))/((exp(y(1))+uueelag__)*(exp(y(1))+uueelag__))));
  g1(149,36)=(-(((exp(y(1))+uueelag__)*(-exp(y(36)))-(exp(y(1))+uuee_t__)*(-exp(y(36))))/((exp(y(1))+uueelag__)*(exp(y(1))+uueelag__))));
  g1(149,42)=exp(y(42));
  g1(149,70)=(-((exp(y(70))*(exp(y(1))+uueelag__)-exp(y(70))*(exp(y(1))+uuee_t__))/((exp(y(1))+uueelag__)*(exp(y(1))+uueelag__))));
  g1(150,52)=exp(y(52));
  g1(150,68)=(-(((1+exp(y(69))+uuemlag__)*(-exp(y(68)))-(uuem_t__+1+exp(y(69)))*(-exp(y(68))))/((1+exp(y(69))+uuemlag__)*(1+exp(y(69))+uuemlag__))));
  g1(150,69)=(-((exp(y(69))*(1+exp(y(69))+uuemlag__)-exp(y(69))*(uuem_t__+1+exp(y(69))))/((1+exp(y(69))+uuemlag__)*(1+exp(y(69))+uuemlag__))));
  g1(150,71)=(-((exp(y(71))*(1+exp(y(69))+uuemlag__)-exp(y(71))*(uuem_t__+1+exp(y(69))))/((1+exp(y(69))+uuemlag__)*(1+exp(y(69))+uuemlag__))));
  g1(151,131)=1-params(279);
  g1(152,132)=1-params(279);
  g1(153,154)=1-params(280);
  g1(154,129)=exp(y(129))-T1265*exp(y(129))*getPowerDeriv(exp(y(129)),params(231),1);
  g1(155,130)=exp(y(130))-T1274*exp(y(130))*getPowerDeriv(exp(y(130)),params(233),1);
  g1(156,133)=(-((-(exp(y(133))*(exp(y(140))+exp(y(147)))))/(exp(y(133))*exp(y(133)))));
  g1(156,140)=(-(exp(y(140))/exp(y(133))));
  g1(156,147)=(-(exp(y(147))/exp(y(133))));
  g1(156,156)=exp(y(156));
  g1(157,157)=1;
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],157,24649);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],157,3869893);
end
end
end
end
